<?php

if (!function_exists('themeoptions')) {

    function themeoptions() {



        $of_options = array();




        /* GENERAL ******************************************************* */
        $of_options[] = array("name" => "General Settings",
            "type" => "headingstart");


        $of_options[] = array("name" => "标志",
            "desc" => "上传你的标志 " . jwUtils::getHelp("main_logo"),
            "id" => "custom_logo",
            "std" => "",
            "type" => "upload");

        $of_options[] = array(
            'id' => 'logo_retina_ready',
            'type' => 'toggle',
            'name' => 'Retina 屏支持',
            'desc' => '标志在 retina 显示支持'.' '. jwUtils::getHelp("retina_ready"),
            'std' => '0'
        );

        $of_options[] = array("name" => "Favicon",
            "desc" => "上传一个 16px * 16px PNG/GIF图像作为网站收藏站标.".' '. jwUtils::getHelp("favicon"),
            "id" => "custom_favicon",
            "std" => "",
            "type" => "upload");


        $of_options[] = array(
            'id' => 'totop_show',
            'type' => 'toggle',
            'name' => '回顶部箭头',
            'desc' => '是否显示 "回顶部" 箭头.'.' '. jwUtils::getHelp("show_totop"),
            'std' => '0'
        );

        $of_options[] = array(
            'id' => 'totop_show_mobile',
            'type' => 'toggle',
            'name' => '在手机设备上显示回顶部箭头',
            'desc' => '',
            'std' => '0'
        );



        $of_options[] = array("type" => "headingend");
        /* GENERAL END ******************************************************* */





        /* SLIDER ************************************************************ */
        $of_options[] = array("name" => "Sliders Settings",
            "type" => "headingstart");

        $of_options[] = array("name" => "来源",
            "desc" => "你幻灯片内容的来源. 选择一个.".' '. jwUtils::getHelp("s_source"),
            "id" => "slider_source",
            "std" => "three",
            "mod" => "small",
            "type" => "select",
            "options" => array("last" => "Latest posts", "sticky" => "Sticky posts", "slides" => "Slides", "shop" => "shop products")
        );


        $of_options[] = array("name" => "幻灯片数量",
            "desc" => "显示幻灯片的最大数量.".' '. jwUtils::getHelp("s_number"),
            "id" => "slider_number",
            "std" => "6",
            "mod" => "small",
            "type" => "text");

        $of_options[] = array("name" => "速度",
            "desc" => "幻灯片的速度. 输入毫秒.".' '. jwUtils::getHelp("s_speed"),
            "id" => "slider_speed",
            "std" => "3500",
            "mod" => "small",
            "type" => "text");
        
        $of_options[] = array("name" => "摘录标题的长度",
            "desc" => "摘录标题的长度. 输入字符数.".' '. jwUtils::getHelp("s_exerpt"), 
            "id" => "slider_excerpt_title",
            "mod" => "small",
            "std" => "50",
            "type" => "text");
        
        $of_options[] = array("name" => "摘录的长度",
            "desc" => "摘录的长度. 输入字符数.".' '. jwUtils::getHelp("s_exerpt"), 
            "id" => "slider_excerpt",
            "mod" => "small",
            "std" => "50",
            "type" => "text");

        $of_options[] = array("name" => "滚动方向",
            "desc" => "设置幻灯片滚动方向.".' '. jwUtils::getHelp("s_direction"),
            "id" => "slider_orientation",
            "std" => "down",
            "mod" => "small",
            "type" => "select",
            "options" => array("up" => "Up", "down" => "Down"));


        $of_options[] = array(
            'id' => 'slider_cat',
            'type' => 'multidropdown',
            'name' => '包含分类',
            'desc' => '选择你想提取文章的文章分类.'.' '. jwUtils::getHelp("s_cat"),
            "std" => array(),
            "page" => null,
            "mod" => 'big',
            "chosen" => "true",
            "target" => 'cat',
            "prompt" => "Choose category..",
        );


        $of_options[] = array(
            'id' => 'slider_sticky',
            'type' => 'toggle',
            'name' => 'Show sticky also in page content',
            'desc' => '',
            'std' => '0'
        );


        $of_options[] = array("type" => "headingend");
        /* SLIDER END ******************************************************** */



        /* BLOG ************************************************************** */
        $of_options[] = array("name" => "Blog",
            "type" => "headingstart");



        $of_options[] = array(
            "name" => "博客页面布局",
            "desc" => "选择主要内容和边栏对齐." . jwUtils::getHelp("b_layout"),
            "id" => "blog_layout",
            "std" => 'right',
            "type" => "layout",
            "extend" => 'blog_sidebar',
            "options" => array(
                'fullwidth' => ADMIN_DIR . 'assets/images/no_sidebar.gif',
                'left' => ADMIN_DIR . 'assets/images/left_sidebar.gif',
                'right' => ADMIN_DIR . 'assets/images/right_sidebar.gif'
            )
        );

        $of_options[] = array(
            'id' => 'blog_sidebar_left',
            'type' => 'sidebar_select',
            'name' => '博客左边栏',
            'desc' => '在这里添加一些可选的边栏.',
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'blog_sidebar_right',
            'type' => 'sidebar_select',
            'name' => '博客右边栏',
            'desc' => '在这里添加一些可选的边栏. 你可以添加自定义边栏在 <b>边栏管理</b>',
            'std' => null,
            'mod' => 'medium'
        );


        $of_options[] = array(
            'id' => 'blog_cat',
            'type' => 'multidropdown',
            'name' => '包含分类',
            'desc' => '选择你想提取文章的文章类别.'.' '. jwUtils::getHelp("b_incl_cat"),
            "std" => array(),
            "page" => null,
            "mod" => 'big',
            "chosen" => "true",
            "target" => 'cat',
            "prompt" => "Choose category..",
        );

        $of_options[] = array(
            'id' => 'blog_featured_allsite',
            'type' => 'toggle',
            'name' => '整站推荐区域',
            'desc' => 'Show Featured area (slider and small top sidebar) on the all site or only on page.',
            'std' => '0'
        );

        $of_options[] = array(
            'id' => 'blog_slider',
            'type' => 'toggle',
            'name' => '幻灯片',
            'desc' => '选择是否显示幻灯片.',
            'std' => '1'
        );




        $of_options[] = array(
            'id' => 'blog_postscount',
            'type' => 'text',
            'name' => '文章数量',
            'desc' => '每页或每批文章数量（加载方法依赖于下面的分页样式）.',
            'std' => '6',
            'max' => '100',
            'maxlength' => '3',
            'mod' => 'micro'
        );
        /*   $of_options[] = array(
          'id' => 'blog_pagescount',
          'type' => 'text',
          'name' => '页面文章数',
          'desc' => 'Number of regular wordpress post pages on one flying news page. (Only ajax scrooling)',
          'std' => '2',
          'max' => '100',
          'maxlength' => '3',
          'mod' => 'micro'
          ); */
        $of_options[] = array(
            'id' => 'blog_pagination',
            'type' => 'select',
            'name' => '分页样式',
            'desc' => '选择分页样式. 详细的请看说明文档.'.' '. jwUtils::getHelp("b_pagination"),
            'std' => 'ajax',
            'mod' => 'medium',
            'options' => array("ajax" => "ajax", "infinite" => "infinite", "infinitemore" => "infinite with more", "none" => "none", "number" => "number", "wordpress" => "wordpress"),
        );

        $of_options[] = array(
            'id' => 'blog_order',
            'type' => 'select',
            'name' => '文章排序',
            'desc' => '文章排序 (升序或降序).'.' '. jwUtils::getHelp("b_post_order"),
            'std' => 'desc',
            'mod' => 'small',
            'options' => array("desc" => "Desc", "asc" => "Asc")
        );

        $of_options[] = array(
            'id' => 'blog_orderby',
            'type' => 'select',
            'name' => '文章排序按',
            'desc' => '文章排序按参数.获得帮助 <a target="_blank" href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters">Order by Parameters</a>'.' '. jwUtils::getHelp("b_post_orderby"),
            'std' => 'date',
            'mod' => 'medium',
            'options' => array("date" => "Date", "none" => "None", "ID" => "ID",
                "author" => "Author", "title" => "Title", "modified" => "Modified",
                "parent" => "Parent", "rand" => "Rand", "comment_count" => "Comment count")
        );

        $of_options[] = array(
            'id' => 'blog_dateformat',
            'type' => 'text',
            'name' => '文章日期格式',
            'desc' => '请访问 <a target="_blank" href="http://codex.wordpress.org/Formatting_Date_and_Time">Wordpress文章日期格式</a> 学习如何使用的字符惯例.'.' '. jwUtils::getHelp("b_date_format"),
            'std' => "F j, Y",
            'mod' => 'mini'
        );


        $of_options[] = array(
            'id' => 'std_post_image_clickable',
            'type' => 'toggle',
            'name' => '超级链接文章图片',
            'desc' => '选择文章以及图像的超链接标题. 设置开启或关闭.'.' '. jwUtils::getHelp("b_hyperlink"),
            'std' => '0'
        );

        $of_options[] = array(
            'id' => 'image_lightbox',
            'type' => 'toggle',
            'name' => '显示灯箱',
            'desc' => '选择是否在点击文章图片后在灯箱打开 (图像, 视频或相册类型 ).'.' '. jwUtils::getHelp("b_im_lightbox"),
            'std' => '1'
        );



        $of_options[] = array(
            "name" => "搜索/存档/分类布局",
            "desc" => "选择一个主要内容和边栏对齐方式.".' '. jwUtils::getHelp("b_sac_layout"),
            "id" => "search_and_archive_layout",
            "std" => 'right',
            "type" => "layout",
            "extend" => 'search_and_archive_sidebar',
            "options" => array(
                'fullwidth' => ADMIN_DIR . 'assets/images/no_sidebar.gif',
                'left' => ADMIN_DIR . 'assets/images/left_sidebar.gif',
                'right' => ADMIN_DIR . 'assets/images/right_sidebar.gif'
            )
        );

        $of_options[] = array(
            'id' => 'search_and_archive_sidebar_left',
            'type' => 'sidebar_select',
            'name' => '搜索/存档左边栏',
            'desc' => '在这里可以添加一些可选侧边栏.'.' '. jwUtils::getHelp("b_sa_sidebar"),
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'search_and_archive_sidebar_right',
            'type' => 'sidebar_select',
            'name' => '搜索/存档右边栏',
            'desc' => '在这里可以添加一些可选侧边栏.'.' '. jwUtils::getHelp("b_sa_sidebar"),
            'std' => null,
            'mod' => 'medium'
        );




        $of_options[] = array("name" => "文字摘录数量",
            "desc" => "在前端内容的文字摘录数.".' '. jwUtils::getHelp("b_number_excerpt"),
            "id" => "blog_excerpt",
            "std" => 20,
            "mod" => 'micro',
            'maxlength' => 4,
            "type" => "text"
        );


        $of_options[] = array(
            'id' => 'blog_category',
            'type' => 'toggle',
            'name' => '分类名称',
            'desc' => '预览是否显示分类名称. Choose on or off.'.' '. jwUtils::getHelp("b_cat_name"),
            'std' => '1'
        );


        $of_options[] = array(
            "name" => "自定义分类",
            "type" => "sectionstart");

        $of_options[] = array(
            'id' => 'custom_sort1',
            'type' => 'toggle',
            'name' => '自定义分类 1',
            'desc' => 'Beside "Date", "Name", "Rating",... sort option, show new sotr item which is can be set at every post.',
            'std' => '0'
        );
        $of_options[] = array(
            'id' => 'custom_sort1_name',
            'type' => 'text',
            'name' => '自定义分类 1 名称',
            'desc' => 'Text which is will be showed net to "Date", "Name", "Rating",...',
            'std' => "Custom sort 1",
            'mod' => 'medium'
        );
        $of_options[] = array(
            'id' => 'custom_sort2',
            'type' => 'toggle',
            'name' => '自定义分类 2',
            'desc' => 'Beside "Date", "Name", "Rating",... sort option, show new sotr item which is can be set at every post.',
            'std' => '0'
        );
        $of_options[] = array(
            'id' => 'custom_sort2_name',
            'type' => 'text',
            'name' => '自定义分类 2 名称',
            'desc' => 'Text which is will be showed net to "Date", "Name", "Rating",...',
            'std' => "Custom sort 2",
            'mod' => 'medium'
        );
        $of_options[] = array(
            "type" => "sectionend");

        /*  read more je zakázaný
         * $of_options[] = array("name" => "Read More Text",
          "desc" => "Zde zadejte readmore text",
          "id" => "blog_readmore",
          "std" => "Read more",
          "mod" => "medium",
          "type" => "text"
          );
         */
        /* METAdata */

        $of_options[] = array(
            "name" => "Meta Data" . ' ' . jwUtils::getHelp("b_meta"),
            "type" => "sectionstart");


        $of_options[] = array(
            "name" => "Meta 条切换",
            "desc" => "选择你的 meta 条切换样式或切换开关. 这个条显示在文章预览页.",
            "id" => "blog_metacaption",
            "std" => "fadeEffect",
            "type" => "select",
            "mod" => "small",
            "options" => array(
                "static" => "Static",
                "toggle" => "Toggle",
                "fadeEffect" => "Fade Effect"
            )
        );



        $of_options[] = array(
            'id' => 'blog_metacategory',
            'type' => 'toggle',
            'name' => 'Meta 分类',
            'desc' => '选择是否在前端显示Meta 分类 .',
            'std' => '1'
        );

        $of_options[] = array(
            'id' => 'blog_metaauthor',
            'type' => 'toggle',
            'name' => 'Meta 作者',
            'desc' => '选择是否显示作者名.',
            'std' => '0'
        );

        $of_options[] = array(
            'id' => 'blog_metadate',
            'type' => 'toggle',
            'name' => 'Meta 日期',
            'desc' => '选择是否显示日期.',
            'std' => '1'
        );

        $of_options[] = array(
            'id' => 'blog_metacomments',
            'type' => 'toggle',
            'name' => 'Meta 评论',
            'desc' => '选择是否显示评论.',
            'std' => '1'
        );

        $of_options[] = array(
            'id' => 'blog_ratings',
            'type' => 'toggle',
            'name' => '评级',
            'desc' => '选择是否显示评级.',
            'std' => '1'
        );

        $of_options[] = array(
            "type" => "sectionend");
        /* Metadata end */


        /* Sortovací lišta */

        $of_options[] = array(
            "name" => "Main Bar" . ' ' . jwUtils::getHelp("b_main"),
            "type" => "sectionstart");


        $of_options[] = array(
            'id' => 'ribbon_show',
            'type' => 'toggle',
            'name' => '主条',
            'desc' => '选择是否显示主条.',
            'std' => '1'
        );

        $of_options[] = array(
            'id' => 'ribbon_sort',
            'type' => 'select',
            'name' => '排序选项',
            'desc' => '选择是否启用排序选项. (Filter is by categories)',
            'std' => '1',
            'mod' => 'medium',
             "options" => array(
                "0" => "Off",
                "1" => "Sort",
                "2" => "Filter"
            )
        );

        $of_options[] = array(
            'id' => 'ribbon_search',
            'type' => 'toggle',
            'name' => '搜索选项',
            'desc' => '选择是否启用搜索选项.',
            'std' => '1'
        );

        $of_options[] = array(
            "type" => "sectionend");



        /* FB comments settings */
        $of_options[] = array(
            "name" => "Facebook 评论".' '. jwUtils::getHelp("b_fb_comm"),
            "type" => "sectionstart");

        $of_options[] = array(
            "name" => "Facebook 评论",
            "id" => "info-fb",
            "text" => "Don't forget insert Facebook App ID in advanced section.",
            "type" => "info",
            "space" => false,
            "message" => "warnings"
        );

        $of_options[] = array(
            'id' => 'fbcomments_switch',
            'type' => 'toggle',
            'name' => 'Facebook 评论',
            'desc' => 'Switch between wordpress and facebook comments',
            'std' => '0'
        );


        $of_options[] = array(
            'id' => 'fbcomments_nuberofcomments',
            'type' => 'text',
            'name' => '评论数量',
            'desc' => 'Enter the number of comments to be displayed.',
            'std' => "5",
            'mod' => 'mini'
        );
        $of_options[] = array(
            "type" => "sectionend");


        $of_options[] = array("type" => "headingend");
        /* BLOG END ****************************************************** */


        /* SINGLE POST ***************************************************** */
        $of_options[] = array("name" => "Single Post",
            "type" => "headingstart");

        $of_options[] = array(
            "name" => "文章布局",
            "desc" => "选择主内容和边栏对齐方式.".' '. jwUtils::getHelp("sp_layout"),
            "id" => "post_layout",
            "std" => 'right',
            "type" => "layout",
            "extend" => 'post_sidebar',
            "options" => array(
                'fullwidth' => ADMIN_DIR . 'assets/images/no_sidebar.gif',
                'left' => ADMIN_DIR . 'assets/images/left_sidebar.gif',
                'right' => ADMIN_DIR . 'assets/images/right_sidebar.gif'
            )
        );

        $of_options[] = array(
            'id' => 'post_sidebar_left',
            'type' => 'sidebar_select',
            'name' => '文章左侧边栏',
            'desc' => '你可以在这里添加一些可选侧边栏. 创建侧边栏到侧边栏管理部分.'.' '. jwUtils::getHelp("sp_sidebar"),
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'post_sidebar_right',
            'type' => 'sidebar_select',
            'name' => '文章右侧边栏',
            'desc' => '你可以在这里添加一些可选侧边栏. 创建侧边栏到侧边栏管理部分.'.' '. jwUtils::getHelp("sp_sidebar"),
            'std' => null,
            'mod' => 'medium'
        );


        $of_options[] = array(
            'id' => 'post_nav_bar',
            'type' => 'toggle',
            'name' => '导航条',
            'desc' => 'Global settings',
            'std' => '1'
        );


        $of_options[] = array(
            'id' => 'post_share',
            'type' => 'toggle',
            'name' => '分享文章条',
            'desc' => '在文章下面是否显示分享条.'.' '. jwUtils::getHelp("sp_share"),
            'std' => '1',
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'post_relatedpost',
            'type' => 'toggle',
            'name' => '相关文章',
            'desc' => '是否在文章页面显示相关文章?',
            'std' => '0',
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'post_relatedpost_num',
            'type' => 'text',
            'name' => '相关文章数量',
            'desc' => '选择相关文章数量.',
            'std' => '4',
            'mod' => 'mini'
        );

        $of_options[] = array(
            'id' => 'post_image_featured',
            'type' => 'toggle',
            'name' => '使用图像作为特色图像',
            'desc' => '',
            'std' => '0',
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'post_use_featured',
            'type' => 'toggle',
            'name' => '在文章使用特色图像或视频或相册',
            'desc' => 'Global settings',
            'std' => '0',
            'mod' => 'medium'
        );
        $of_options[] = array(
            'id' => 'post_pp_galery',
            'type' => 'toggle',
            'name' => '为相册使用灯箱效果.',
            'desc' => '',
            'std' => '0',
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'blog_author',
            'type' => 'toggle',
            'name' => '关于作者',
            'desc' => 'Choose whether the autors name with photo and description is displayed or not in a post.'.' '. jwUtils::getHelp("b_author"),
            'std' => '1'
        );


        $of_options[] = array(
            'id' => 'post_in_same_category',
            'type' => 'toggle',
            'name' => '相同分类的上一个和下一个按钮.',
            'desc' => 'Indicates whether previous post must be within the same category as the current post.',
            'std' => '0'
        );

        $of_options[] = array(
            "name" => "Meta 选项",
            "type" => "sectionstart");
        $of_options[] = array(
            'id' => 'post_author',
            'type' => 'toggle',
            'name' => 'Meta 文章作者',
            'desc' => '显示作者名',
            'std' => '1',
            'mod' => 'medium'
        );
        $of_options[] = array(
            'id' => 'post_date',
            'type' => 'toggle',
            'name' => 'Meta 文章日期',
            'desc' => '显示文章发布日期',
            'std' => '1',
            'mod' => 'medium'
        );



        $of_options[] = array(
            "type" => "sectionend");

        $of_options[] = array(
            "name" => "分享选项" . ' ' . jwUtils::getHelp("sp_share_opt"),
            "type" => "sectionstart");

        $of_options[] = array(
            'id' => 'post_share_tw',
            'type' => 'toggle',
            'name' => '分享文章到 Twitter',
            'std' => '1',
            'mod' => 'medium'
        );
        $of_options[] = array(
            'id' => 'post_share_fb',
            'type' => 'toggle',
            'name' => '分享文章到 Facebook',
            'std' => '1',
            'mod' => 'medium'
        );
        $of_options[] = array(
            'id' => 'post_share_g',
            'type' => 'toggle',
            'name' => '分享文章到 Google',
            'std' => '1',
            'mod' => 'medium'
        );
        $of_options[] = array(
            'id' => 'post_share_li',
            'type' => 'toggle',
            'name' => '分享文章到 LinkedIn',
            'std' => '1',
            'mod' => 'medium'
        );
        $of_options[] = array(
            'id' => 'post_share_pi',
            'type' => 'toggle',
            'name' => '分享文章到 Pinterest',
            'std' => '1',
            'mod' => 'medium'
        );


        $of_options[] = array(
            "type" => "sectionend");


        $of_options[] = array("type" => "headingend");
        /* STYLING END ****************************************************** */


        /* SIDEBAR MANAGER ************************************************** */
        $of_options[] = array("name" => "Sidebar Manager",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'sidebars',
            'type' => 'sidebars',
            'name' => '自定义侧边栏',
            'desc' => '在这里添加一些可选侧边栏.'.' '. jwUtils::getHelp("sm_sidebars"),
            'std' => null
        );

        $of_options[] = array("type" => "headingend");
        /* STYLING END ******************************************************* */


        /* STYLING *********************************************************** */
        $of_options[] = array("name" => "Styling Options",
            "type" => "headingstart");

        $of_options[] = array(
            "name" => "模板背景设置".' '. jwUtils::getHelp("templ_back"),
            "type" => "sectionstart");

        $of_options[] = array("name" => "背景图像",
            "desc" => "更新你的背景图像.",
            "id" => "background_image",
            "std" => "",
            "mod" => "big",
            "type" => "upload");

        $bg_images_url = get_template_directory_uri() . '/images/bg_texture/';
        $bg_images = jwUtils::fileLoader(STYLESHEETPATH . '/images/bg_texture/', array('.png', '.jpg'), $bg_images_url = get_template_directory_uri() . '/images/bg_texture/');

        $bg = array("none" => get_template_directory_uri() . '/images/bg_texture/' . $bg_images_url . 'lil_fiber.png');

        $of_options[] = array("name" => "背景纹理",
            "desc" => "选择背景纹理.如果你选择 cross filled box, 就没有纹理.",
            "id" => "background_texture",
            "std" => $bg_images_url . "lil_fiber.png",
            "type" => "tiles",
            "options" => $bg_images,
        );        
        
        $of_options[] = array("name" => "背景颜色",
            "desc" => "为主题选择自定义背景颜色(默认: #F1F4ED).",
            "id" => "body_background_color",
            "std" => "#F1F4ED",
            "type" => "color");

        $of_options[] = array(
            "type" => "sectionend"
        );
        
       $of_options[] = array(
            "name" => "模板样式设置". jwUtils::getHelp("templ_styling"),
            "type" => "sectionstart");

        $bg_images_url = get_template_directory_uri() . '/images/cat_bg_color/';
        $of_options[] = array("name" => "模板主颜色",
            "desc" => "选择模板颜色.",
            "id" => "template_body_main_color",
            "std" => "darkgrey",
            "type" => "tiles",
            "index" => true,
            "mod" => "big",
            "options" => array(
                "lightblue" => $bg_images_url . 'cat_lightblue.png',
                "blue" => $bg_images_url . 'cat_blue.png',
                "cyan" => $bg_images_url . 'cat_cyan.png',
                "darkblue" => $bg_images_url . 'cat_darkblue.png',
                "navy" => $bg_images_url . 'cat_navy.png',
                "purple" => $bg_images_url . 'cat_purple.png',
                "lightgreen" => $bg_images_url . 'cat_lightgreen.png',
                "lime" => $bg_images_url . 'cat_lime.png',
                "green" => $bg_images_url . 'cat_green.png',
                "darkgreen" => $bg_images_url . 'cat_darkgreen.png',
                "yellow" => $bg_images_url . 'cat_yellow.png',
                "orange" => $bg_images_url . 'cat_orange.png',
                "red" => $bg_images_url . 'cat_red.png',
                "darkred" => $bg_images_url . 'cat_darkred.png',
                "pink" => $bg_images_url . 'cat_pink.png',
                "salmon" => $bg_images_url . 'cat_salmon.png',
                "grunge" => $bg_images_url . 'cat_grunge.png',
                "darkgrey" => $bg_images_url . 'cat_darkgrey.png',
                "custom" => $bg_images_url . 'cat_custom.png',
            ),
        );

        $of_options[] = array("name" => "模板自定义主颜色",
            "desc" => "Pick a custom template color for the theme (by default: #CA181F).",
            "id" => "body_main_color",
            "std" => "#CA181F",
            "type" => "color");

        $of_options[] = array("name" => "模板自定义背景颜色",
            "desc" => "Template custom Font Color (by default: #ffffff).",
            "id" => "body_main_font_color",
            "std" => "#ffffff",
            "type" => "color");

        $of_options[] = array("name" => "模板链接颜色",
            "desc" => "Pick a link color for the theme (by default: #000000).",
            "id" => "body_main_color_link",
            "std" => "#000000",
            "type" => "color");

        $of_options[] = array("name" => "模板链接悬停颜色",
            "desc" => "Pick a link hover color for the theme (by default: #CA181F).",
            "id" => "body_main_color_link_hover",
            "std" => "#CA181F",
            "type" => "color");

        $of_options[] = array(
            'id' => 'body_font',
            'type' => 'text',
            'name' => '标题字体',
            'desc' => 'Here you can change the title font. This doesnt affect the font size, typeface and color remain standard. <a href="http://www.google.com/webfonts">Use font from this web</a>',
            'std' => "Oswald",
            'mod' => 'big'
        );

        $of_options[] = array("name" => "段落字体",
            "desc" => "Copy the font name (e. g. 'Denk One') here and choose a size, style and color. <a href='http://www.google.com/webfonts'>Use font from this web</a>",
            "id" => "small_font",
            "std" => array('size' => '13px', 'face' => 'Droid Sans', 'style' => 'normal', 'color' => '#000000'),
            "type" => "typography");

        $of_options[] = array(
            "type" => "sectionend"
        );

        $of_options[] = array("type" => "headingend");
        /* STYLING END ******************************************************* */

        /* CUSTOM ************************************************************* */
        $of_options[] = array("name" => "Custom Code",
            "type" => "headingstart");

        $of_options[] = array("name" => "自定义 CSS",
            "desc" => "Simply add some CSS to your theme by adding it to this field.",
            "id" => "custom_css",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("name" => "自定义 Javascript 页脚",
            "desc" => "Simply add some javascript to your theme by adding it to this field.",
            "id" => "custom_js",
            "std" => "",
            "type" => "textarea");
        
        $of_options[] = array("name" => "自定义 Javascript 页眉",
            "desc" => "Simply add some javascript to your theme by adding it to this field.<strong> Use it for Google DFP.</strong> For custom code add 'script' tag",
            "id" => "custom_js_header",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("name" => "Google 分析",
            "desc" => "Paste your Google Analytics (or other) tracking code here. This will be added into the footer template of your theme.",
            "id" => "google_analytics",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("name" => "页脚文字",
            "desc" => "You can use the following shortcodes in your footer text: [wp-link] [theme-link] [loginout-link] [blog-title] [blog-link] [the-year]",
            "id" => "footer_text",
            "std" => 'Copyright © 2013 Design by <a href="http://www.jawtemplates.com">Jawtemplates.com</a>.',
            "type" => "textarea");




        $of_options[] = array("type" => "headingend");
        /* CUSTOM END ************************************************** */

        /* BANNERTY  ********************************************************* */


        //background
        $of_options[] = array("name" => "Banner Background",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'background_banner_show',
            'type' => 'toggle',
            'name' => '显示广告条',
            'desc' => 'Show Banner',
            'std' => '0'
        );

        $of_options[] = array("name" => "广告背景",
            "desc" => "上传你的广告图像.",
            "id" => "background_banner",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "广告背景图像链接",
            "desc" => "输入广告链接.",
            "id" => "background_banner_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        
        $of_options[] = array("name" => "广告链接目标",
            "desc" => "定义链接目标.",
            "id" => "background_lead_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("type" => "headingend");



        //leader
        $of_options[] = array("name" => "Banner Leader",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'leader_banner_show',
            'type' => 'toggle',
            'name' => '显示横幅广告',
            'desc' => 'Show Banner',
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅广告类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_leader_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));

        $of_options[] = array("name" => "横幅广告领导者",
            "desc" => "Upload your image banner.",
            "id" => "leader_banner",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅广告领导者图像链接",
            "desc" => "Fill in the banner link.",
            "id" => "leader_banner_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        
        $of_options[] = array("name" => "横幅广告链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_lead_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "插入谷歌广告代码. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "leader_banner_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");




        // top
        $of_options[] = array("name" => "Banner Header 468x60",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'header_banner_show',
            'type' => 'toggle',
            'name' => '显示横幅广告',
            'desc' => 'Show Banner'.' '. jwUtils::getHelp("adv_header"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅广告类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_header_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));

        $of_options[] = array("name" => "顶部横幅广告 468x60",
            "desc" => "Upload your image banner.",
            "id" => "header_banner",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "顶部横幅广告图像链接",
            "desc" => "Fill in the banner link.",
            "id" => "header_banner_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        
        $of_options[] = array("name" => "横幅广告链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_head_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "header_banner_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");


        // Skyscrapper - Right
        $of_options[] = array("name" => "Banner - Skyscrapper Right",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'skyscrapper_right_show',
            'type' => 'toggle',
            'name' => 'Show Banner',
            'desc' => 'Choose whether the banner is displayed or not.' . ' ' . jwUtils::getHelp("adv_right"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅广告类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_skyscrapper_right_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));


        $of_options[] = array("name" => "Banner - Skyscrapper Right",
            "desc" => "Upload your image banner.",
            "id" => "skyscrapper_right",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅广告链接",
            "desc" => "Fill in the banner link.",
            "id" => "skyscrapper_right_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        $of_options[] = array("name" => "横幅广告链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_ss_r_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));


        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "skyscrapper_right_link_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");


        // Skyscrapper left
        $of_options[] = array("name" => "Banner - Skyscrapper Left",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'skyscrapper_left_show',
            'type' => 'toggle',
            'name' => 'Show Banner',
            'desc' => 'Show Banner' . ' ' . jwUtils::getHelp("adv_left"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅广告类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_skyscrapper_left_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));

        $of_options[] = array("name" => "横幅广告 - Skyscrapper Left",
            "desc" => "Upload your image banner.",
            "id" => "skyscrapper_left",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅广告链接",
            "desc" => "Fill in the banner link.",
            "id" => "skyscrapper_left_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        $of_options[] = array("name" => "横幅广告链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_ss_l_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "skyscrapper_left_link_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");


        // Banner into Post - 1 
        $of_options[] = array("name" => "Banner - Post 1",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'banner_post_1_show',
            'type' => 'toggle',
            'name' => '显示横幅广告',
            'desc' => 'Choose whether the banner is displayed or not.'.' '. jwUtils::getHelp("adv_post"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅广告类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_post_1_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));


        $of_options[] = array("name" => "横幅 - 文章 1",
            "desc" => "Upload your image banner.",
            "id" => "banner_post_1",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅广告链接",
            "desc" => "Fill in the banner link.",
            "id" => "banner_post_1_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        $of_options[] = array("name" => "横幅广告链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_1_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "banner_post_1_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");

        // Banner into Post - 2 
        $of_options[] = array("name" => "Banner - Post 2",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'banner_post_2_show',
            'type' => 'toggle',
            'name' => '显示横幅广告',
            'desc' => 'Choose whether the banner is displayed or not.'.' '. jwUtils::getHelp("adv_post"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅广告类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_post_2_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));


        $of_options[] = array("name" => "横幅广告 - 文章 2",
            "desc" => "Upload your image banner",
            "id" => "banner_post_2",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅广告链接",
            "desc" => "Fill in the banner link.",
            "id" => "banner_post_2_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        $of_options[] = array("name" => "横幅广告链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_2_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "banner_post_2_google",
            "std" => "",
            "type" => "textarea");


        $of_options[] = array("type" => "headingend");

        // Banner into Post - 3 
        $of_options[] = array("name" => "Banner - Post 3",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'banner_post_3_show',
            'type' => 'toggle',
            'name' => '显示横幅广告',
            'desc' => 'Choose whether the banner is displayed or not.'.' '. jwUtils::getHelp("adv_post"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_post_3_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));


        $of_options[] = array("name" => "横幅 - 文章 3",
            "desc" => "Upload your image banner.",
            "id" => "banner_post_3",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅链接",
            "desc" => "Fill in the banner link.",
            "id" => "banner_post_3_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        
        $of_options[] = array("name" => "横幅链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_3_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "banner_post_3_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");



        // Banner IN TOP POST 
        $of_options[] = array("name" => "Banner - in post top",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'banner_posttop_show',
            'type' => 'toggle',
            'name' => '显示横幅广告',
            'desc' => 'Choose whether the banner is displayed or not.'.' '. jwUtils::getHelp("adv_custom"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_posttop_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));


     
        $of_options[] = array("name" => "横幅 - 文章顶部",
            "desc" => "Upload your image banner.",
            "id" => "banner_posttop",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅链接",
            "desc" => "Fill in the banner link.",
            "id" => "banner_posttop_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        $of_options[] = array("name" => "横幅链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_posttop_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "banner_posttop_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");


        // Banner IN Bottom POSt
        $of_options[] = array("name" => "Banner - in post bottom",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'banner_postbottom_show',
            'type' => 'toggle',
            'name' => '显示横幅广告',
            'desc' => 'Choose whether the banner is displayed or not.'.' '. jwUtils::getHelp("adv_custom"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_postbottom_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));


     
        $of_options[] = array("name" => "横幅 - 文章底部",
            "desc" => "Upload your image banner.",
            "id" => "banner_postbottom",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅链接",
            "desc" => "Fill in the banner link.",
            "id" => "banner_postbottom_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        $of_options[] = array("name" => "横幅链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_postbottom_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "banner_postbottom_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");



        // Banner Custom Widget - 1 
        $of_options[] = array("name" => "Banner - Custom 1",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'banner_custom_1_show',
            'type' => 'toggle',
            'name' => 'Show Banner',
            'desc' => 'Choose whether the banner is displayed or not.' . ' ' . jwUtils::getHelp("adv_custom"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_custom_1_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));


     
        $of_options[] = array("name" => "横幅 - 小工具 1",
            "desc" => "Upload your image banner.",
            "id" => "banner_custom_1",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅链接",
            "desc" => "Fill in the banner link.",
            "id" => "banner_custom_1_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        $of_options[] = array("name" => "横幅链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_w_1_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "banner_custom_1_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");

        // Banner into Post - 1 
        $of_options[] = array("name" => "Banner - Custom 2",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'banner_custom_2_show',
            'type' => 'toggle',
            'name' => 'Show Banner',
            'desc' => 'Choose whether the banner is displayed or not.' . ' ' . jwUtils::getHelp("adv_custom"),
            'std' => '0'
        );

        $of_options[] = array("name" => "横幅类型",
            "desc" => "Choose the banner type you prefer.",
            "id" => "banner_custom_2_type",
            "std" => "image",
            "type" => "select",
            "options" => array("image" => "Image Banner", "google" => "Google Ads"));


        $of_options[] = array("name" => "横幅 - 小工具 2",
            "desc" => "Upload your image banner.",
            "id" => "banner_custom_2",
            "std" => "",
            "type" => "upload");

        $of_options[] = array("name" => "横幅链接",
            "desc" => "Fill in the banner link.",
            "id" => "banner_custom_2_link",
            "std" => "http://",
            'maxlength' => 255,
            "type" => "text"
        );
        $of_options[] = array("name" => "横幅链接目标",
            "desc" => "Define a link target.",
            "id" => "banner_w_2_link_target",
            "std" => "_blank",
            "type" => "select",
            "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

        $of_options[] = array("name" => "谷歌广告代码",
            "desc" => "Insert the Google Ads Code. <b>Notice: You can have maximally 3 google ads on one page.</b>",
            "id" => "banner_custom_2_google",
            "std" => "",
            "type" => "textarea");

        $of_options[] = array("type" => "headingend");

        /* END BANNERS ******************************************************* */

        /* 404  **************************************************** */
        $of_options[] = array("name" => "Error 404",
            "type" => "headingstart");



        $of_options[] = array("name" => "404 HTML",
            "desc" => "Insert the Error 404 page HTML code." . ' ' . jwUtils::getHelp("error_404"),
            "id" => "error_custom_html",
            "rows" => 20,
            "std" => '		<h1>File Not Found</h1>
				<div class="error">
					<p class="bottom">The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</p>
				</div>
				<p>Please try the following:</p>
				<ul> 
					<li>Return to the <a href="' . SITE_URL . '">home page</a></li>
				</ul>',
            "type" => "textarea");

        $of_options[] = array(
            "name" => "404 页面布局",
            "desc" => "Select sidebar alignment.",
            "id" => "error_layout",
            "std" => 'right',
            "type" => "layout",
            "extend" => 'error_sidebar',
            "options" => array(
                'fullwidth' => ADMIN_DIR . 'assets/images/no_sidebar.gif',
                'left' => ADMIN_DIR . 'assets/images/left_sidebar.gif',
                'right' => ADMIN_DIR . 'assets/images/right_sidebar.gif'
            )
        );

        $of_options[] = array(
            'id' => 'error_sidebar_left',
            'type' => 'sidebar_select',
            'name' => '404 页面左侧边栏',
            'desc' => 'Here you can add some optional sidebars.',
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'error_sidebar_right',
            'type' => 'sidebar_select',
            'name' => '404 页面右侧边栏',
            'desc' => 'Here you can add some optional sidebars. You can add custom sidebar in <b>Sidebar Manager</b>',
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array("type" => "headingend");




        /* BACKUP  **************************************************** */
        $of_options[] = array("name" => "Backup Options",
            "type" => "headingstart");

        $of_options[] = array("name" => "备份和重置选项",
            "id" => "of_backup",
            "std" => "",
            "type" => "backup",
            "desc" => 'You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.' . ' ' . jwUtils::getHelp("backup_opt"),
        );

        $of_options[] = array("name" => "转换主题选项数据",
            "id" => "of_transfer",
            "std" => "",
            "type" => "transfer",
            "desc" => "You can transfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click Import Options." . ' ' . jwUtils::getHelp("backup_transfer_theme"),
        );

        $of_options[] = array("type" => "headingend");


        // DEMO **********************************************************
        $of_options[] = array("name" => "Demo Data",
            "type" => "headingstart");

        $of_options[] = array(
            "name" => "导入演示 DEMO",
            "id" => "info-demo",
            "text" => "<h3 style=\"margin: 0 0 10px;\">Warning:</h3> When uploading the demo content you may lose your data. Please dont forget to back-up your database before you choose this option.<br><br> When you import the demo at the first time, the whole data will be imported. You will get only the presets at the next updates.<br><br>Import only on clean Wordpress.",
            "type" => "info",
            "space" => false,
            "message" => "warnings"
        );



        $of_options[] = array(
            "name" => "导入演示数据".' '. jwUtils::getHelp("demo_import"),
            "space" => true,
            "id" => "import-sample-preset1",
            "file" => array("demo1"),
            "description" => array("Click the thumbnail to make your site look like our demo.<br /><b>Please read carefully the Warning above before you do this.</b>"),
            "img" => array("demo1.jpg"), //in /demo/images folder
            "type" => "importpreset"
        );



        $of_options[] = array("type" => "headingend");


        // Advanced **********************************************************
        $of_options[] = array("name" => "Advanced",
            "type" => "headingstart");

        $of_options[] = array(
            'id' => 'site_rtl',
            'type' => 'toggle',
            'name' => '左到右',
            'desc' => 'Support for RTL languages',
            'std' => '0'
        );


        $of_options[] = array(
            'id' => 'switch_udate',
            'type' => 'toggle',
            'name' => '新版本通知',
            'desc' => 'Choose whether you want to be informed about new available updates.'.' '. jwUtils::getHelp("a_update"),
            'std' => '1'
        );

        $of_options[] = array(
            'id' => 'social_comments_language',
            'type' => 'text',
            'name' => '本地化语言',
            'desc' => 'To change the language use a value from <a href="'.THEME_URI.'/languages/language_code.html?amp;TB_iframe=true" class="thickbox">this</a> list.'.' '. jwUtils::getHelp("a_lng"),
            'std' => "en_GB",
            'mod' => 'mini'
        );

        $of_options[] = array(
            'id' => 'fbcomments_appid',
            'type' => 'text',
            'mod' => 'large',
            'name' => 'Facebook App ID',
            'desc' => 'For sharing your site and create FB commentary. For more information please visit <a href="https://developers.facebook.com">developers.facebook.com</a>.',
            'std' => "",
        );

        $of_options[] = array(
            'id' => 'fbcomments_moderated',
            'type' => 'button',
            'name' => 'Comment Moderation Area',
            'desc' => "When you're a moderator you will see notifications within facebook.com. If you don't want to have moderator status or want to see all comments in one area, use the link to the left.",
            'std' => '1',
            'href' => 'https://developers.facebook.com/tools/comments',
            'title' => 'Comment Moderation Area',
            'target' => '_blank'
        );

        //START TWITTER
        $of_options[] = array(
            "name" => "Twitter API",
            "type" => "sectionstart");

        $of_options[] = array(
            'id' => 'tw_consumer_id',
            'type' => 'text',
            'mod' => 'large',
            'name' => '自定义 id',
            'desc' => 'To get this item please go to: <a href="https://dev.twitter.com/apps/new">https://dev.twitter.com/apps/new</a>',
            'std' => "",
        );
        $of_options[] = array(
            'id' => 'tw_consumer_secret',
            'type' => 'text',
            'mod' => 'large',
            'name' => '自定义秘密',
            'desc' => 'To get this item please go to: <a href="https://dev.twitter.com/apps/new">https://dev.twitter.com/apps/new</a>',
            'std' => "",
        );
        $of_options[] = array(
            'id' => 'tw_access_id',
            'type' => 'text',
            'mod' => 'large',
            'name' => '访问令牌',
            'desc' => 'To get this item please go to: <a href="https://dev.twitter.com/apps/new">https://dev.twitter.com/apps/new</a>',
            'std' => "",
        );
        $of_options[] = array(
            'id' => 'tw_access_secret',
            'type' => 'text',
            'mod' => 'large',
            'name' => '访问令牌秘密',
            'desc' => 'To get this item please go to: <a href="https://dev.twitter.com/apps/new">https://dev.twitter.com/apps/new</a>',
            'std' => "",
        );


        $of_options[] = array(
            "type" => "sectionend");
        //END TWITTER
        //START INSTAGRAM
        $of_options[] = array(
            "name" => "<i class='icon-instagram'></i> Instagram API",
            "type" => "sectionstart");

        $of_options[] = array(
            "name" => "Instagram info",
            "id" => "Instagram-info",
            "text" => '<b>1.</b> Create a new application <a href="http://instagram.com/developer/clients/manage/#">HERE</a>.<br><br><b>Set the "Redirect URI" to "' . SITE_URL . '/wp-admin/themes.php?page=optionsframework"</b>. <br><br>Get both the "Client ID" and the "Client Secret" keys and paste them into the appropriate fields below.
                        <br><br>Save the Theme Options and refresh the page (Ctrl+F5).
                        <br><br>
                        <b>2.</b> Now click on the "Get Instagram Access Token". 
                        <br><br>Save the Theme Options and refresh the page again.
                        <br><br>
                        <i>To get your USER ID, please click <a href="http://jelled.com/instagram/lookup-user-id">here</a> (you need this ID for setting up the J&W - Social Widget).</i>',
            "type" => "info",
            "space" => false,
            "message" => "info"
        );

        $of_options[] = array(
            'id' => 'i_client_id',
            'type' => 'text',
            'mod' => 'large',
            'name' => 'App Client id',
            'desc' => 'To get this item please go to: <a href="http://instagram.com/developer/clients/manage/#">http://instagram.com/developer/clients/manage/#</a>',
            'std' => "",
        );

        $of_options[] = array(
            'id' => 'i_client_secret',
            'type' => 'text',
            'mod' => 'large',
            'name' => 'App Client secret',
            'desc' => 'To get this item please go to: <a href="http://instagram.com/developer/clients/manage/#">http://instagram.com/developer/clients/manage/#</a>',
            'std' => "",
        );


        $of_options[] = array(
            'id' => 'instagram_token',
            'type' => 'instagram',
            'name' => 'Instagram App',
            'desc' => 'Numbers before dot - is your User ID',
            'std' => "",
        );

        $of_options[] = array(
            "type" => "sectionend");


        $of_options[] = array(
            "name" => "Comments antispam question",
            "type" => "sectionstart");


        $of_options[] = array(
            'id' => 'comments_antispam_toggle',
            'type' => 'toggle',
            'name' => 'Turn on comments antispam question',
            'desc' => 'This option add antispam question to comment box.',
            'std' => '0'
        );


        $of_options[] = array(
            'id' => 'comments_antispam_question',
            'type' => 'text',
            'mod' => 'large',
            'name' => 'Comments antispam question',
            'desc' => '',
            'std' => "1+1=",
        );
        $of_options[] = array(
            'id' => 'comments_antispam_answer',
            'type' => 'text',
            'mod' => 'large',
            'name' => 'Comments antispam answer',
            'desc' => '',
            'std' => "2",
        );



        $of_options[] = array(
            "type" => "sectionend");
        $of_options[] = array(
            "name" => "SEO",
            "type" => "sectionstart"
        );


        $of_options[] = array(
            'id' => 'use_jaw_seo',
            'type' => 'toggle',
            'name' => '使用内置 SEO',
            'desc' => 'You can deactivate build-in SEO if you want to use some SEO plugin.',
            'std' => '1',
        );



        $of_options[] = array(
            "type" => "sectionend"
        );

        $of_options[] = array("type" => "headingend");






        // WooCommerce **********************************************************
        $of_options[] = array("name" => "Woocommerce",
            "type" => "headingstart");


        $of_options[] = array(
            'id' => 'woo_display_on_main',
            'type' => 'toggle',
            'name' => '混合产品和文章'.' '. jwUtils::getHelp("woocomm"),
            'desc' => 'Display product in the main blog, or display posts in shop if you have set shop as your homepage.',
            'std' => '1'
        );
        $of_options[] = array(
            'id' => 'woo_fequency_display_on_main',
            'type' => 'text',
            'mod' => 'large',
            'name' => 'Frequency product boxes',
            'desc' => 'Every X post boxes is showing as product box',
            'std' => "4"
        );

        $of_options[] = array(
            'id' => 'woo_choose_product',
            'type' => 'multidropdown',
            'name' => '显示产品',
            'desc' => 'Choose what product will appear on the main page between your posts.',
            "std" => array(),
            "page" => null,
            "mod" => 'big',
            "chosen" => "true",
            "target" => 'products',
            "prompt" => "Choose products..",
        );
        
         $of_options[] = array("name" => "在页眉哪显示购物车",
            "desc" => "Choose where you want a cart in header to be shown.",
            "id" => "woo_main_cart",
            "std" => "ecomm",
            "type" => "select",
            "options" => array("ecomm" => "eCommerce", "all_web" => "All site", "none" => "none")
        );

        /* Product */
        $of_options[] = array(
            "name" => "Product Page" . ' ' . jwUtils::getHelp("product_page"),
            "type" => "sectionstart");


        $of_options[] = array(
            "name" => "产品页布局",
            "desc" => "Select sidebar alignment." ,
            "id" => "product_layout",
            "std" => 'right',
            "type" => "layout",
            "extend" => 'woo_sidebar',
            "options" => array(
                'fullwidth' => ADMIN_DIR . 'assets/images/no_sidebar.gif',
                'left' => ADMIN_DIR . 'assets/images/left_sidebar.gif',
                'right' => ADMIN_DIR . 'assets/images/right_sidebar.gif'
            )
        );

        $of_options[] = array(
            'id' => 'woo_sidebar_left',
            'type' => 'sidebar_select',
            'name' => '产品左侧边栏',
            'desc' => 'Here you can add some optional sidebars.',
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'woo_sidebar_right',
            'type' => 'sidebar_select',
            'name' => '产品右侧边栏',
            'desc' => 'Here you can add some optional sidebars. You can add custom sidebar in <b>Sidebar Manager</b>',
            'std' => null,
            'mod' => 'medium'
        );



        $of_options[] = array(
            'id' => 'woo_nav_bar',
            'type' => 'toggle',
            'name' => '在产品页面显示导航条',
            'desc' => 'Choose this option if you want to display the nav bar in individual products.',
            'std' => '1'
        );



        $of_options[] = array(
            "type" => "sectionend");



        /* Product CAT */
        $of_options[] = array(
            "name" => "产品类别".' '. jwUtils::getHelp("product_category"),
            "type" => "sectionstart");

        $of_options[] = array(
            "name" => "产品类别布局",
            "desc" => "Select sidebar alignment.",
            "id" => "product_cat_layout",
            "std" => 'right',
            "type" => "layout",
            "extend" => 'product_cat_sidebar',
            "options" => array(
                'fullwidth' => ADMIN_DIR . 'assets/images/no_sidebar.gif',
                'left' => ADMIN_DIR . 'assets/images/left_sidebar.gif',
                'right' => ADMIN_DIR . 'assets/images/right_sidebar.gif'
            )
        );

        $of_options[] = array(
            'id' => 'product_cat_sidebar_left',
            'type' => 'sidebar_select',
            'name' => '产品分类左侧边栏',
            'desc' => 'Here you can add some optional sidebars.',
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'product_cat_sidebar_right',
            'type' => 'sidebar_select',
            'name' => '产品分类右侧边栏',
            'desc' => 'Here you can add some optional sidebars. You can add custom sidebar in <b>Sidebar Manager</b>',
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array(
            "type" => "sectionend");




        /* Product TAG */
        $of_options[] = array(
            "name" => "Product Tag",
            "type" => "sectionstart");

        $of_options[] = array(
            "name" => "产品标签布局",
            "desc" => "Select sidebar alignment.",
            "id" => "product_tag_layout",
            "std" => 'right',
            "type" => "layout",
            "extend" => 'product_tag_sidebar',
            "options" => array(
                'fullwidth' => ADMIN_DIR . 'assets/images/no_sidebar.gif',
                'left' => ADMIN_DIR . 'assets/images/left_sidebar.gif',
                'right' => ADMIN_DIR . 'assets/images/right_sidebar.gif'
            )
        );

        $of_options[] = array(
            'id' => 'product_tag_sidebar_left',
            'type' => 'sidebar_select',
            'name' => '产品标签左侧边栏',
            'desc' => 'Here you can add some optional sidebars.',
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array(
            'id' => 'product_tag_sidebar_right',
            'type' => 'sidebar_select',
            'name' => '产品标签右侧边栏',
            'desc' => 'Here you can add some optional sidebars. You can add custom sidebar in <b>Sidebar Manager</b>',
            'std' => null,
            'mod' => 'medium'
        );

        $of_options[] = array(
            "type" => "sectionend");





        $of_options[] = array("type" => "headingend");










        $menu['generalsettings'] = array('submenu' => 0, 'name' => '常规设置');
        $menu['blog'] = array('submenu' => 0, 'name' => '博客');
        $menu['singlepost'] = array('submenu' => 0, 'name' => '文章内页');
        $menu['sidebarmanager'] = array('submenu' => 0, 'name' => '侧边栏管理');
        $menu['customcode'] = array('submenu' => 0, 'name' => '自定义代码');
        $menu['stylingoptions'] = array('submenu' => 0, 'name' => '样式选项');
        $menu['advertisementd'] = array('submenu' => 1, 'name' => '广告管理');
       // $menu['bannerbackground'] = array('submenu' => 1, 'name' => '横幅广告背景'); - jedine bez vodkazu, nebo s js
        $menu['bannerleader'] = array('submenu' => 1, 'name' => '横幅广告领导者');
        $menu['bannerheader468x60'] = array('submenu' => 1, 'name' => '页眉横幅广告 468x60');
        $menu['banner-skyscrapperright'] = array('submenu' => 1, 'name' => '横幅广告 - Skyscraper Right');
        $menu['banner-skyscrapperleft'] = array('submenu' => 1, 'name' => '横幅广告 - Skyscraper Left');
        $menu['banner-post1'] = array('submenu' => 1, 'name' => '横幅广告 - 文章 1');
        $menu['banner-post2'] = array('submenu' => 1, 'name' => '横幅广告 - 文章 2');
        $menu['banner-post3'] = array('submenu' => 1, 'name' => '横幅广告 - 文章 3');
        $menu['banner-post3'] = array('submenu' => 1, 'name' => '横幅广告 - 文章 3');
        $menu['banner-post3'] = array('submenu' => 1, 'name' => '横幅广告 - 文章 3');
        $menu['banner-inposttop'] = array('submenu' => 1, 'name' => '横幅广告 - 文章顶部');
        $menu['banner-inpostbottom'] = array('submenu' => 1, 'name' => '横幅广告 - 文章底部');
        $menu['banner-custom1'] = array('submenu' => 1, 'name' => '横幅广告 - 自定义 1');
        $menu['banner-custom2'] = array('submenu' => -1, 'name' => '横幅广告 - 自定义 2');
        $menu['sliderssettings'] = array('submenu' => 0, 'name' => '幻灯片设置');
        $menu['error404'] = array('submenu' => 0, 'name' => '错误 404');
        $menu['backupoptions'] = array('submenu' => 0, 'name' => '备份');
        $menu['demodata'] = array('submenu' => 0, 'name' => '演示');
        $menu['advanced'] = array('submenu' => 0, 'name' => '高级');
        $menu['woocommerce'] = array('submenu' => 0, 'name' => 'Woocommerce');





        return array($of_options, $menu);
    }

}
?>
